program PlatformaIzolacyjna1;

uses
  SysUtils,
  DUnitX.TestFramework,
  DUnitX.Loggers.Console,
  DUnitX.Windows.Console,
  Delphi.Mocks in 'Delphi.Mocks.pas',
  Delphi.Mocks.Behavior in 'Delphi.Mocks.Behavior.pas',
  Delphi.Mocks.Helpers in 'Delphi.Mocks.Helpers.pas',
  Delphi.Mocks.Interfaces in 'Delphi.Mocks.Interfaces.pas',
  Delphi.Mocks.MethodData in 'Delphi.Mocks.MethodData.pas',
  Delphi.Mocks.Utils in 'Delphi.Mocks.Utils.pas',
  Delphi.Mocks.VirtualInterface in 'Delphi.Mocks.VirtualInterface.pas',
  Delphi.Mocks.When in 'Delphi.Mocks.When.pas',
  Delphi.Mocks.Expectation in 'Delphi.Mocks.Expectation.pas',
  Delphi.Mocks.ObjectProxy in 'Delphi.Mocks.ObjectProxy.pas',
  Delphi.Mocks.Proxy in 'Delphi.Mocks.Proxy.pas',
  Delphi.Mocks.VirtualMethodInterceptor in 'Delphi.Mocks.VirtualMethodInterceptor.pas',
  Delphi.Mocks.ReturnTypePatch in 'Delphi.Mocks.pas';

type
  IDziennik = interface(IInvokable)
    ['{B571A28D-A576-4C83-A0D3-CB211435CDEA}']
    procedure Wpisz(aString: string);
  end;

type
  TPrzelicznikDolarówNaGaleony = class
  private
    FDziennik: IDziennik;
  public
    constructor Create(aDziennik: IDziennik);
    function PrzeliczDolaryNaGaleony(aDolary: Double; aKurs: Double): Double;
  end;

function TPrzelicznikDolarówNaGaleony.PrzeliczDolaryNaGaleony(aDolary, aKurs: Double): Double;
begin
  Result := aDolary * aKurs;
  FDziennik.Wpisz(Format('Zamiana %f dolarów na %f galeony', [aDolary, Result]));
end;

constructor TPrzelicznikDolarówNaGaleony.Create(aDziennik: IDziennik);
begin
  inherited Create;
  FDziennik := aDziennik;
end;

// --------------------------------------------------------------------------------
type
  [TestFixture]
  TTestPrzelicznikaDolarówNaGaleony = class
  public
    [Test]
    procedure TestZamianyDwóchDolarów;
    [Test]
    procedure TestPrawidłowegoWywołaniaDziennika;
  end;

procedure TTestPrzelicznikaDolarówNaGaleony.TestZamianyDwóchDolarów;
var
  WartośćOczekiwana: Double;
  WartośćRzeczywista: Double;
  TymczPrzelicznik: TPrzelicznikDolarówNaGaleony;
  TymczDziennik: TMock<IDziennik>;
begin
  // Przygotuj
  TymczDziennik := TMock<IDziennik>.Create;
  TymczPrzelicznik := TPrzelicznikDolarówNaGaleony.Create(TymczDziennik);
  try
    WartośćOczekiwana := 1.0;
    // Wykonaj
    WartośćRzeczywista := TymczPrzelicznik.PrzeliczDolaryNaGaleony(2, 0.5);
    // Sprawdź
    Assert.AreEqual(WartośćOczekiwana, WartośćRzeczywista, 'Przelicznik błędnie zamienił 2 dolary na 1 galeona');
  finally
    TymczPrzelicznik.Free;
  end;
end;

procedure TTestPrzelicznikaDolarówNaGaleony.TestPrawidłowegoWywołaniaDziennika;
var
  WartośćOczekiwana: Double;
  WartośćRzeczywista: Double;
  TymczPrzelicznik: TPrzelicznikDolarówNaGaleony;
  TymczDziennik: TMock<IDziennik>;
  WartośćWejściowa: Double;
  TymczKomunikat: string;
begin
  // Przygotuj
  TymczDziennik := TMock<IDziennik>.Create;
  WartośćWejściowa := 2.0;
  WartośćOczekiwana := 1.0;
  TymczKomunikat := Format('Zamiana %f dolarów na %f galeony', [WartośćWejściowa, WartośćOczekiwana]);
  TymczDziennik.Setup.Expect.Once.When.Wpisz(TymczKomunikat);
  TymczPrzelicznik := TPrzelicznikDolarówNaGaleony.Create(TymczDziennik);
  try
    // Wykonaj
    WartośćRzeczywista := TymczPrzelicznik.PrzeliczDolaryNaGaleony(WartośćWejściowa, 0.5);
    // Sprawdź
    TymczDziennik.Verify();
  finally
    TymczPrzelicznik.Free;
  end;
end;

var
  Runner: ITestRunner;
  Logger: ITestLogger;
  Results: IRunResults;

begin
  TDUnitX.RegisterTestFixture(TTestPrzelicznikaDolarówNaGaleony);
  try
    // Utworzenie zmiennej testowej
    Runner := TDUnitX.CreateRunner;
    Runner.UseRTTI := True;
    // Wskazanie sposobu rejestrowania wyników testów
    Logger := TDUnitXConsoleLogger.Create;
    Runner.AddLogger(Logger);
    // Wykonanie testów
    Results := Runner.Execute;
    System.Write('Koniec. Naciśnij <Enter> aby zakończyć.');
    System.Readln;
  except
    on E: Exception do
      System.Writeln(E.ClassName, ': ', E.Message);
  end;
end.